//------------------------------------------------------------
// Copyright Sandlot Games, 2007
// author: Michael Felice
// file: client_prop.cs
// brief:
//    This handles all of the client-side prop details
//    that need to be address when the prop is first
//    created (not from a mission file when loaded)
//------------------------------------------------------------



//*************************************************************
//                CLIENT-SIDE PROP STATES
//*************************************************************

// this function is called once when a prop is created for
// the first time (not when it is loaded from a mission file,
// only when it is newly created)
function PropClient::onInitialize(%this, %input)
{
   %object = getWord(%input, 0);
   %component = getWord(%input, 1);
   %datablock = %component.getDataBlock();
   
   // Send object create message
   slgSendObjCreateMsg(%object, true);
}

// this is called when the prop is added on the client-side
function PropClient::onAdd(%this, %input)
{
   %object = getWord(%input, 0);
   %component = getWord(%input, 1);
   %datablock = %component.getDataBlock();
}

// this function is called once on every tick for the client-side
// prop object
function PropClient::onUpdate(%this, %input)
{
   %object = getWord(%input, 0);
   %component = getWord(%input, 1);
   %datablock = %component.getDataBlock();
}

// this function is called when the prop object is removed
function PropClient::onRemove(%this, %input)
{
   %component = getWord(%input, 0);
   %datablock = %component.getDataBlock();
}
